// dymaxion car    

#declare car_shape=
difference {
 merge {
  cone { <-1,0,0>,1,<1,0,0>,1.3 }
  sphere { <-0.90,0,0>,1 }
  sphere { <1.30,0,0>,1.3325 }
 }
 box { <-3,-2,-3>, <3,-1.0,3> }
 scale < 1, 0.6, 0.8 >
}


#declare body_with_cut_outs=
difference {
 object { car_shape }
 object { car_shape scale 0.95 }
 difference { 
  // window void
  box { <-0.5,-0.0,-2>,<3,0.6,2>} 
  //frames
  box { < 0.2,-0.0,-2>,<0.25,0.6,2>}
  box { < 0.9,-0.0,-2>,<0.95,0.6,2>}
  box { < 1.6,-0.0,-2>,<1.65,0.6,2>}
  // lateral
  box { < 1.65, 0.29,-2>,<3.0,0.31,2>}
  // vert centre
  box { < 1.5, -0.3,-.01>,<3,0.5,0.01>}
  // mid panel
  box { < 0.2,-0.0,-2>,<0.90,0.6,2>}
 }  
texture { pigment { color rgb < 0.9,0.8,0.8 > } }
finish { ambient 0.3 phong 0.4 reflection 0.3}
}

#declare car_front_windows=
object { car_shape
scale 0.99
texture { pigment { color rgbt < 0.1,0.1,0.2, 0.6 > } }
finish { ambient 0.1 }
}

#declare wh=-0.40;
#declare wheels=
union {
 cylinder { <-1.3, wh, -0.15>,<-1.3, wh,  0.15 >, 0.35 } // back wheel 
 cylinder { < 0.7, wh, -0.75>,< 0.7, wh, -0.95 >, 0.35 } // front left wheel 
 cylinder { < 0.7, wh,  0.75>,< 0.7, wh,  0.95 >, 0.35 } // front right wheel 
 texture { pigment { color rgbt < 0.1,0.1,0.2, 0.0 > } }
 finish { ambient 0.3  }
}


#declare dymaxion_car=
merge {
object { body_with_cut_outs }
object { car_front_windows }
object { wheels }
translate 1.35*y
scale 2.5
} 

object { dymaxion_car 
//rotate -90*y
//rotate 180*y 
//rotate -90*x
//rotate -20*x
//translate < -170,13,600>
scale 0.5
translate < 20,0,130>
}


